﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;


/* a simple custom activity with plain properties and events.
   It uses a custom validator for its properties */
namespace Lessons.Workflows.Activities
{

    [ActivityValidator(typeof(InputActivityValidator))]
	public partial class InputActivity: Activity
	{
        string title = "<dialog title>";
        string text = "<dialog text>";
        string input = "";
        bool result = false;        

		public InputActivity()
		{
			InitializeComponent();
		}

        protected override ActivityExecutionStatus Execute(ActivityExecutionContext context)
        {

            if (BeforeDialog != null)
                BeforeDialog(this, EventArgs.Empty);

            result = InputDialog.Execute(Title, Text, ref input);


            if (AfterDialog != null)
                AfterDialog(this, EventArgs.Empty); 

            /* return a status to indicate that the activity is complete */
            return ActivityExecutionStatus.Closed;
        }


        /* properties */
        [Browsable(true)]
        public string Title { get { return title; } set { title = value; } }

        [Browsable(true)]
        public string Text { get { return text; } set { text = value; } }

        [Browsable(true)]
        public string Input { get { return input; } set { input = value; } }

        [Browsable(true)]
        public bool Result { get { return result; } set { result = value; } }


        /* events */
        [Browsable(true)]
        public event EventHandler BeforeDialog;

        [Browsable(true)]
        public event EventHandler AfterDialog;
	}



    /* a simple validator for InputActivity properties */
    public class InputActivityValidator : ActivityValidator
    {
        public override ValidationErrorCollection ValidateProperties(ValidationManager manager, object obj)
        {
            /* errorList is the return data and stores any errors found  */
            ValidationErrorCollection errorList = base.ValidateProperties(manager, obj);

            InputActivity a = obj as InputActivity;
            if (a != null)
            {
                if (string.IsNullOrEmpty(a.Title))
                    errorList.Add(ValidationError.GetNotSetValidationError("Title"));

                if (string.IsNullOrEmpty(a.Text))
                    errorList.Add(ValidationError.GetNotSetValidationError("Text"));

            }


            return errorList;
        }
    }
}
